/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.textfield;

import filenet.vw.toolkit.utils.uicontrols.textfield.IVWMaskElement;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskCondition;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskException;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskExpression;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskSet;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskToken;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskTokenizer;

class VWMaskParser {
    VWMaskParser() {
    }

    public IVWMaskElement parseMacro(String text) {
        VWMaskTokenizer tokenizer = new VWMaskTokenizer("&|![]() ", "");
        tokenizer.tokenize(text);
        return this.parseCondition(tokenizer);
    }

    public IVWMaskElement parseCondition(VWMaskTokenizer tokenizer) {
        IVWMaskElement node = this.parseExpression(tokenizer);
        IVWMaskElement result = null;
        if (tokenizer.hasMoreTokens()) {
            VWMaskToken next = tokenizer.nextToken();
            if (next.equals('|')) {
                result = new VWMaskCondition(false, node, this.parseCondition(tokenizer));
            } else if (next.equals('&')) {
                result = new VWMaskCondition(true, node, this.parseCondition(tokenizer));
            }
        } else {
            tokenizer.ignoreToken();
            result = node;
        }
        return result;
    }

    private IVWMaskElement parseExpression(VWMaskTokenizer tokenizer) {
        VWMaskToken token = tokenizer.nextToken();
        IVWMaskElement result = null;
        if (token.equals('(')) {
            IVWMaskElement node = this.parseCondition(tokenizer);
            VWMaskParser.expect(tokenizer.nextToken(), ')');
            result = new VWMaskExpression(node);
        } else {
            tokenizer.ignoreToken();
            result = this.parseSet(tokenizer);
        }
        return result;
    }

    private IVWMaskElement parseSet(VWMaskTokenizer tokenizer) {
        VWMaskParser.expect(tokenizer.nextToken(), '[');
        VWMaskToken token = tokenizer.nextToken();
        boolean negate = token.equals('!');
        if (negate) {
            token = tokenizer.nextToken();
        }
        VWMaskParser.expect(tokenizer.nextToken(), ']');
        return new VWMaskSet(negate, this.expandSet(token.m_text));
    }

    private String expandSet(String text) {
        int i = 0;
        StringBuffer buffer = new StringBuffer();
        while (i < text.length()) {
            if (i < text.length() - 2 && text.charAt(i + 1) == '-') {
                int to;
                int from = text.charAt(i);
                if (from > (to = text.charAt(i + 2))) {
                    int temp = from;
                    from = to;
                    to = temp;
                }
                for (int c = from; c <= to; ++c) {
                    buffer.append((char)c);
                }
                i += 3;
                continue;
            }
            buffer.append(text.charAt(i));
            ++i;
        }
        return buffer.toString();
    }

    public static void expect(VWMaskToken token, char chr) {
        if (!token.equals(chr)) {
            throw new VWMaskException("Syntax error: '" + chr + "' expected at " + token.m_pos);
        }
    }

    public static void main(String[] args) {
        VWMaskParser parser = new VWMaskParser();
        IVWMaskElement element = parser.parseMacro("[0-9]");
        System.out.println(element);
        System.out.println(element.match('3'));
    }
}

